#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw( $opt_d $opt_s );

MAIN : {
    &init();

    my @cur;      # buffer of lines of current fold
    my $line;
    my @cur_scop; # scop infor for last 
    my @scop;     # scop info for this entry
    my @head;     # things on the header line
    my $a = 1;    # BOOLEAN => TRUE IF WE SHOULD SEND
                  # current buffer to .A
    
    open( DBIN, $opt_d ) or die ( "$opt_d: $!" );
    open( DBOUTA, ">$opt_d.A" ) or die( "$opt_d.A: $!" );
    open( DBOUTB, ">$opt_d.B" ) or die( "$opt_d.B: $!" );
    
    while ( <DBIN> ) {
	
	# next entry
	if ( /^>/ ) {
	    @head = split( /\s+/ );
	    @scop = split( /\./, $head[ 1 ] );
	    
	    unless ( &sameFold( \@scop, \@cur_scop ) ) {
		
		# We're done with this class/fold combo ->
		# send it to the right db
		$a = &goToA( $a, \@cur_scop, );
		if ( $a ) {
		    foreach $line ( @cur ) {
			print DBOUTA ( $line );
			$a = 0;
		    }
		}
		else {
		    foreach $line ( @cur ) {
			print DBOUTB ( $line );
		    }
		    $a = 1;
		}
		@cur = ();
	    }
	    @cur_scop = @scop;
	}
	push( @cur, $_ );
	
    }

    # Now deal with this last one
    $a = &goToA( $a, \@cur_scop, );
    if ( $a ) {
	foreach $line ( @cur ) {
	    print DBOUTA ( $line );
	    $a = 0;
	}
    }
    else {
	foreach $line ( @cur ) {
	    print DBOUTB ( $line );
		    }
    }

    close ( DBIN );
    close ( DBOUTA );
    close ( DBOUTB );

}

sub sameFold {
    my $scop_p   = shift;
    my $c_scop_p = shift;
    
    return 1 unless $c_scop_p->[ 0 ];

    if ( ( $scop_p->[ 0 ] eq $c_scop_p->[ 0 ] ) &&
	 ( $scop_p->[ 1 ] eq $c_scop_p->[ 1 ] ) ) {
	return 1;
    }

    else {
	return 0;
    }
}

sub goToA {
    my $a = shift;
    my $scop_p = shift;
    my @scop;

    if ( $opt_s == 1 ) {
	# every other fold
	return $a;
    }

    else {
	# odd numbered folds of odd numbered
	# class to .A, etc.
	@scop = &convertScop( $scop_p );
	if ( int( ( $scop[ 0 ] + $scop[ 1 ] ) / 2 ) ==
	     ( $scop[ 0 ] + $scop[ 1 ] ) / 2 ) {
	    return 1;
	}
	else {
	    return 0;
	}
    }
}

sub convertScop {
    my %convert = ( 'a' => 1,
		    'b' => 2,
		    'c' => 3,
		    'd' => 4,
		    'e' => 5,
		    'f' => 6,
		    'g' => 7 );
    my $scop_p = shift;
    my @scop;
    
    $scop[ 0 ] = $convert{ $scop_p->[ 0 ] };
    $scop[ 1 ] = $scop_p->[ 1 ];
    $scop[ 2 ] = $scop_p->[ 2 ];
    $scop[ 3 ] = $scop_p->[ 3 ];
    
    return @scop;
}
		    

sub init {
    getopts( 'd:s:' );
    unless( $opt_d ) {
	print( "splitAstralByFold.pl\n" );
	print( "Takes a fasta formatted Astral database\n" );
	print( "with scop classification info on the\n" );
	print( "header line.  Creates two new databases\n" );
	print( "each having approximately half the entries\n" );
	print( "of the source.  The two output databases\n" );
	print( "each have one half of the scop folds.  They\n" );
	print( "are given the suffixes .A and .B  Only works\n" );
	print( "if the input database is ordered by SCOP\n" );
	print( "classification which is not the case for\n" );
	print( "some early ASTRAL databases (pre 1.50, I think.\n" );

	print( "OPTIONS:\n" );
	print( "-d [ input database - REQUIRED ]\n" );
	print( "-s [ split algorithm:\n" );
	print( "     1 = folds are split\n" );
	print( "     sequentially into each of the two\n" );
	print( "     output databases.\n" );
	print( "     2 = odd numbered folds of odd numbered\n" );
	print( "     classes are put in .A; Even numbered\n" );
	print( "     folds of odd numbered classes in .A;\n" );
	print( "     everything else is .B\n" );
	print( "     DEFAULT = 2 ]\n" );
	exit( 0 );
    }

    unless( $opt_s == 1 ) {
	$opt_s = 2;
    }
}
