

#ifndef __CBT_SEQ_H__
#define __CBT_SEQ_H__



//! A bilogical sequence. Typically a protein
//! or DNA sequence.
typedef struct cbt_seq_str {
  char *  id ;         //< Sequence id
  char * comment;      //< A comment string
  char * alphabet;     //< The alphabet of the sequence
  int    len;          //< The length of the sequence
  char * sym ;         //< The sequence, encoded according to the alphabet
} cbt_seq;



cbt_seq *
cbt_seq_alloc(void);

cbt_seq * 
cbt_seq_free(cbt_seq * self);

int 
cbt_seq_read_fasta(cbt_seq * self,
                   FILE * stream,
                   const char * alphabet,
                   const bool ignore_case
                   );

int
cbt_seq_write_fasta(const cbt_seq * seq,
                    FILE * stream);

int
cbt_encode(const char * alphabet, 
           const bool ignore_case,
           const size_t len,
           char * vec);




extern const char 
cbt_alphabet_amino_acid_canonical[];

extern const char 
cbt_alphabet_amino_acid_alpha[];

extern const char 
cbt_alphabet_amino_acid_iupac[];

extern const char 
cbt_alphabet_amino_acid_ext[];


#endif /* __GSL_SEQ_H__ */
